<?php  // ۞//  text { encoding:utf-8  ; bom:no ;  linebreaks:unix  ; tabs:4sp ; }
												 $machine['version'] = '0.9.4b';
/*
	Welcome to corz distro machine pro!

	For much more info, see..

		http://corz.org/server/tools/distromachine/

	;o) Cor

	(c) 2004->tomorrow! cor + corz.org ;o)


	IMPORTANT!!!:

	*IF* you have zlib compression enabled on your site, it can interfere with
	the download process - typically, the download will start strong, then slow
	to a crawl and take a long long time to eventually finish, during which time
	most users will have clicked <cancel>.

	Simply add a line to your .htaccess file for the machine's folder..

		php_value zlib.output_compression off

	There is an .htaccess included, with some suggested settings inside. If you
	run php as a cgi (a la phpsuexec) set this in your local php.ini, instead..

		zlib.output_compression = off

	If you still experience any weirdness, LET ME KNOW! preferable with the
	actual errors you are receiving, if any. Ta!

	It should also be noted, that on some servers, it's not a problem.

*/



/*
	Preferences..	*/

// I keep my prefs and stuff in here..
//require_once $_SERVER['DOCUMENT_ROOT'].'/inc/init.php'; // (also includes the logger)


/*	Secure area..		[true/false]

	You can setup a secure download area
	only folks with a password can see the menus, and download the files

	DO NOT password protect a machine that you intend to use for backend menus
	or download/source services, i.e. embedded stuff. Create a separate machine
	for this.
*/
$machine['secure_area']					= false; // if set to true, embedded services will NOT be available!
$machine['area_password']				= '';

/*
	note: when logged in as admin (set password below) you are automatically
	logged in to the secure download area. If you run multiple machines, a login
	in to any one of them (if they all have the same admin (stats) password)
	means you can enter and leave them *all* at will, until you logout again.
*/


/*
	Admin/Stats Password

	If you leave this blank, everyone can view your download stats.
	In that case, note: admin editing functions are disabled, not
	that there's many.

	Note: if this is blank, your pajamas installation is not needed.
													*/
//$machine['password']					= 'password';

// A better idea is to grab it from somewhere in the filesystem..
// NOTE: you need php 4.3 to use file_get_contents, but you could hack in older functions..
$machine['password']	= file_get_contents($_SERVER['DOCUMENT_ROOT'].'/.private/.ht_password');
//
// Inside that file is your password in plain text, and nothing else. no linebreaks, nothing.


// Miscelleneous pajamas prefs you can set. see pajamas for more details.
//
$machine['check_ip'] = false;
$machine['do_time_out'] = true;
$machine['session_time'] = 600;	// minutes	[600 = ten hours]
$machine['big_luser'] = 7;



// Used for errors, such as "mail the webmaster", but it could easily be "mail bob"
// Enter some word or phrase here that you wish to use for "the owner" of this machine.
//
$machine['owner']						= 'the webmaster';


$machine['admin_email']					= 'machine-admin@mydomain.com';

/*
	note:	the email address is "mashed" to ensure it doesn't become easy-pickings
			for the spam-bots. It's still wise to use a "public" address, though.
*/


/*
	pajamas prefs...			[string: file path]

	[for admin authentication]

	Yes, it's a completely different login system from the "secure area".
	this is by design.													*/


// Path to pajamas installation, relative to this script.
// if you begin the path with a "/", it will be taken from the root of your site.
$machine['pajamas_location']			= 'inc/pajamas/pajamas.php';

/*
	If you already have pajamas installed somewhere else on site (admin page, blog, etc)
	it makes sense to point the distro machine to that installation, and delete the
	pajamas folder from inside the distro machine/inc.
*/

/*
	pajamas session name		[string]

	Name of your pajamas session. If you run multiple pajamas-aware applications
	you might want them to use the same session, and therefore the same login.
	I find a site-wide login to be most handy..										*/
$machine['pajamas_sess_name']			= 'pajamas';


/*
	pajamas module				[string]

	Choose from 'pj' (default, Javascript MD5 hashing), 'shaggie' (same, but SHA1)
	and 'plain', where no javascript is available (the moon?).
*/
$machine['module']						= 'pj';  //



/*	The "stats" link appears at the bottom right of all the machine's regular
	pages. if set to false, the stats page will not be available, either	*/
$machine['stats_link']					= true;	//	true/false


// If set to true, the link will be invisible (but still active - mouse around)
$machine['hide_stats_link']				= false;




/*	Default menu system..		[string: 'download' or 'source']

	If you have both menu's enabled, which will be the default?

	When a user goes to the URL directly, this is what they will get
	note: this does not affect the distro machine's backend functions	*/
$machine['default_mode']				= 'download';



/*
	Show download menu?		[true/false]

	Note: this won't disable backend capabilites, nor the ability to
	download files from the source view pages. this is for the menu only.
	if you are using the distro machine purely as a backend download engine,
	you can set both menus to false and the 'nothing available' page will
	catch any stray download requests, broken links, nosey folks, etc

	I really wanted the word carburettor in that paragraph, och well,
	another day.

	NOTE: if you want to provide embedded download menus inside your pages,
	you need to enable this.
				*/
$machine['show_download_menu']			= true;	//	true/false

/*
	Download services?			[true/false]

	Whether to provide backend download services. if you are allowing *any*
	file downloads; either from the menu, from the source view pages, or
	from other parts of your site; you MUST leave this set to true
	*/
$machine['allow_downloads_services']	= true;	//	boolean

/*
	Path to download folder		[default: $machine['source_path'] = 'download/';]
	(where the downloads are) relative to *this* file.

	You can use './' and keep everything in one folder, if you like. It's
	messy, sure, but might be easier for folks wanting a simple download
	station.
	*/
$machine['download_path']				= 'download/';

/*
	File types we will allow users to download
	these will automatically appear in the menu, others will not.

	Separate file extensions with a comma..
	*/
$machine['file_extensions'] = 'zip,rar,sit,gz,tgz,gzip,bzip,bz2,7z,arc,mp3,ogg,m3u,jpg,jpeg,gif,png';

// Extensions for the source viewing are below this section.

/*
	or just show everything..		[false]

	(boolean)	default: $machine['show_all_files'] = false;

	Won't show files beginning with a "." (dot) or directories,
	but shows *everything* else. so don't leave stuff lying around!
	doesn't apply to "source" folders.

	Originally hacked in to view/download uploaded files at an old host
	(there was no other way to do it!) it's proven useful since, and remains..

	NOTE: THIS IS DANGEROUS IN A NON-PASSWORD PROTECTED AREA!!!

	*/
$machine['show_all_files']				= false;


/*
	Multimedia downloading			[true/false]

	(boolean)	default: $machine['multimedia'] = false;

	Normally we send "attachment" headers with each download, so the user gets
	the file in their download folder, or download manager, or whatever catches
	their downloads.

	However, if you use the distro machine to distribute images, mp3's, etc,
	you may wish to enable this setting; that header won't be sent, and instead
	the user's browser will be left to interpret the mime-type of the image/audio
	/video/whatever. not all browsers handle this the same way, but if their
	mime-types are correctly configured (usually), they will get images in their
	browser window, mp3's in their media player, etc, and *should* still get any
	zips and other files exactly as before, ie. downloaded.
	*/
$machine['multimedia']					= false;

/*

	Always send these file types as "attachments".

	If Multimedia downloading is enabled (above), the distro
	machine will still send the following file types as proper
	attachments, ensuring their file names don't get mangled,
	and the browser will correctly handle them (i.e. they won't
	be displayed in the browser)

	separate file extensions with commas..
																				*/
$machine['always_attach']			= 'zip,rar,sit,gz,tgz,gzip,bzip,bz2,7z,arc';


/*
	Enable source menu?			[true/false]

	This is used for documents, source, readme's, etc. things folk read.

	Set to false if you are using solely for downloads. clearly if you don't
	show the source menu AND don't show the download menu, there isn't going
	to be a lot to see. but of course, this might be what you want.
	*/
$machine['show_source_menu']			= false;

/*
	Enable source-highlighting services?		[true/false]

	Set to false to disable back-end source highlighting services
	if you are using the source viewer, source menu, or embedded source highlighting
	services, you *MUST* set this to true
	*/
$machine['source_highlighting']			= true;	//	true/false

/*
	Source folder path	[string: default: $machine['source_path'] = 'source/';]
	that's relative to *this* file.
	*/
$machine['source_path']					= 'source/';

/*

	The source viewer accepts .php .phps and .inc extensions, and the text viewer
	handles anything else, providing rudimentary syntax highlighting to all manner
	of file types. the code is based on my .. http://corz.org/source/textview.php

	(that's not the correct link, but the distro machine will find it for you!)

	Enter all file extensions you would like th distro machine to handle,
	separated by commas..
*/

// source viewer can show..
$machine['source_file_extensions']	= 'inc,ini,css,phps,php,au3,ahk,c,bat,sh,nfo,txt,conf,pl,cpp,cfg';


/*
	Note: You can still have the source/download functionality operating when
	download and source directories are the SAME DIRECTORY. So you can throw
	all your related files together, and still have them appear in separate
	switchable source / download menus.

	Where there are corresponding source/download "pairs" (file.doc and
	file.zip are next to each other), they will get the automatic "download"
	links in their source/document viewer pages.

	You can also disable source viewing and add source file extensions to the
	download extensions so they appear in the menu and can be downloaded (the
	files will be sent directly to the browser's downloads, not shown).

	Versatile, it is.

*/



/*
	Do sections?		[true/false]

	if the source or download folders contain other folders, the distro
	machine will create a "sections" menu enabling users to browse within
	these folders. don't forget to pass &section=whatever if you are accessing
	files inside sub-sections from embedded backend embedded menus. also don't
	forget to put downloads inside corresponding subfolders if you want the
	"download" link on the source view page (if you use that) to appear.

	I'm considering a dynamic zipper for source files, but I kinda like being
	able to have two *slightly* different versions of a file, one to see, and
	one to download. the one to see (and run onsite) often has debug lines,
	for instance. some zips also include "extra" files, scripts, etc, things
	like the website-sync package, let me know how you feel about this.

	Note: you can create sections inside sections, and more sections inside
	them, and so on, and so on, as deep as you like.
	*/
$machine['do_sections']					= true;	//	true/false



/*
	Main "sections" title...			[string]

	this is the main section title that always takes you back to root.
	the ToolTip reads "up to the top"

	*/
$machine['sections_title']				= 'goodies';



/*
	Download counter file				[string: file path]

	Default is '.ht_downloads', but for some reason you may want another..
	note: files beginning .ht are (usually) automatically protected from direct
	access by the web server, so .ht_something is a good idea.
	*/
$machine['counter_file']				= 'inc/data/.ht_downloads';


/*
	Temporary backup file

	File used for temporary backups (every time a write operation is performed)
	if your score file is ever reset to zero (for some unknown reason)
	this file will be used to recover the most recent scores..

	The directory that this file lives in must be writable
	*/
$machine['counter_bax']				= 'inc/data/bax/.ht_downloads_bax';


/*
	Custom text	file				[string: name of custom text file]

	You can put custom text inside your distro machine menus, and at the
	foot of the page (the old way). put some plain text or html into a file,
	inside whatever folder you want the text to apply, you can have a different
	one for each folder. keep it fairly short and snappy, and call it..
	*/
$machine['custom_text_file']			= 'readme.htm';


/*
	Readme.htm or readme.txt are good choices, apache servers, by default
	use these for the footers of "fancy indexed" directories. in other words,
	we can re-use our directory readme's, or run both simultaneously, if you
	wish.

	Briefly; if you *also* place a file called readme.html, along with a
	header.html and our machine's readme.htm, you have a folder that can be
	accessed directly, and via the machine. most useful for source folder,
	see the sample in the distro, and..	http://corz.org/machine/source/
*/


/*	titles..
*/
$machine['downloads_title']				= 'download';
$machine['source_title']				= 'source';

//	you might prefer..
//	$machine['downloads_title']			= 'file';
//	$machine['source_title']			= 'code';
//	or something



/*
	Source/Download switch at foot.

	These days, the titlke is also an active source/download switch,
	but if you like, you can keep the old switch link under the machine
	box. It does knoock the visual balance off a bit, though.
*/
$machine['bottom_switch']	= false;


/*
	External css file

	Enter the location of your css file.

	Paths begining with a forward slash are taken to mean "from site root", without
	the forward slash they are interpreted as being "relative to the page" (html 101),
	so if the css is in a subfolder of the machine, use something like..

	$machine['main_css']	= 'inc/css/groovy.css';

	This setting is used only if running in stand-alone mode. When embedded, you
	can include your page's css, or include the machine.css on that page, which
	gives you much more control.

	An example css file is provided, though note, I *generate* my css files at
	run-time, so what I've included with the machine is a generated version.

	The live version is here..

		http://corz.org/machine/inc/css/machine.css?deminify

*/
$machine['main_css']					= 'inc/css/machine.css';

/*
	NOTE:

	You can include multiple sheets, separating them with commans, e.g..
	$machine['main_css']				= '/styles/site.css,inc/css/machine.css,inc/css/bfix.css';

*/


/*
	Essential Functions..

	Enter either a full path (from system root) or else a relative path from
	this file.
																			*/
$machine['functions_location'] = 'inc/machine-functions.php';

/*
	Text Viewer Functions..

	Again, enter either a full path (from system root) or else a relative path
	from this file. Or, if you aren't using any of the text features of the
	distro machine, leave it blank or delete the pref entirely.
																			*/
$machine['textview_location'] = 'inc/textview.php';





/*
	Advanced Preferences..
							*/


/*
	"my self"

	The name this script is running under. it's clearer and handier to put
	it here, enables us to do a cool "short links" and syndication..	*/


/*
	The normal setting..
																	*/
$machine['self']						= $_SERVER['SCRIPT_NAME'];

/*
	short link
	cool (mod_redirect-ed) setting..

	see http://corz.org/server/tools/distromachine/faq.php for more details
																			*/
//$machine['self']						'/machine';

/*
	If you are syndicating your downloads, you *must* specify the entire path
	including your domain (where the files are)
																		*/
//$machine['self']						= 'http://corz.org'.$_SERVER['SCRIPT_NAME'];

// It goes without saying, then, that if you use the domain-less methods,
// other sites won't be able to meaningfully embed your menus.

/*
	or full manual path..
	with syndication and "short-link".

	or whateveryoulike..
																	*/
//$machine['self']						= 'http://corz.org/beta';


//	IMPORTANT:	If you are syndicating your distro machine, remember to disable
//				Hot-Link protection!


// it's *unlikely* you'll need to alter this..
$machine['root']					=	realpath($_SERVER['DOCUMENT_ROOT']);

// the host can probably be left as-is, unless you know better..
$machine['host']					=	$_SERVER['HTTP_HOST'];




/*
	If you are enabling access to distro machine's built-in page generation
	(stand-alone), you may want to include some site-specific files..
*/

/*
	Site MetaData

	This is placed inside the <heads> tags of generated pages.
	Generally used for metadata.
*/
$machine['site_metadata'] = 'inc/example-metadata.php';


/*
	Site Header

	This is placed right after the <body> tag opens. Generally used for
	navigation includes and such.
*/
$machine['site_header'] = 'inc/example-header.php';


/*
	Site Footer

	This is inserted right before the closing </body> tag.
*/
$machine['site_footer'] = 'inc/example-footer.php';



/*

	Google Analytics code.

	By default, corz distro machine uses the "example-headers.php" file
	(inside inc/) to insert meta-data into the generated pages.

	Inside that file, is the top part of the two-part Google Analytics JavaScript.
	And inside that, is your Google ID.

	The second part is in example-footer.php

	So, this is just an example, a demo, if you like, of the sort of thing
	you might want to do with your meta-data includes.

										*/
$machine['ga_code'] = 'UA-31003967-1';





/*	Moved files...
*/

/*
	If you *move* a file, you can simply let the distro machine catch and
	redirect the old links automatically, or you can add an entry here.

	If you *rename* a file, you will DEFINITELY want to add an entry here..
																					*/
$catchers = array (
	'-- old location --'			=>	'-- new location --',
	'darkstat_osx.dmg.zip'			=>	'/osx/soft/darkstat.php', // leech prevention

	'website-sync.php'				=>	'/engine?section=php&source=website-sync-mac.php' // moved file
	);

// note you can redirect to wherever you want, including another downloadable file
// see Active Error Pages (aka. 404) for more elaborate manouevers.

// IMPORTANT: If you rename files, and add a catchers entry, and you wish to
// remove the stats for the old download, do that BEFORE you add the catcher
// entries, or else (depending on how you setup your catchers) every time you
// try to delete the entry, you will download the new file! or, even more annoying;
// if you use only the file name in the catcher entries, you will delete the stats
// for the new file!

// So.. Delete the old stat, THEN rename, THEN add catcher entries.


// setup some php values..

// we only want genuine visitors..
@ini_set('session.use_trans_sid', 'off');


// the colors for the php (.php/.phps/.inc) source highlighing..
@ini_set('highlight.comment',	'#FF8000');
@ini_set('highlight.default',	'#0000BB');
@ini_set('highlight.html',		'#000000');
@ini_set('highlight.keyword',	'#007700');
@ini_set('highlight.string',	'#DD0000');

@ini_set('zlib.output_compression ',	'Off');


//$site_scheme['textview_delims']
//$site_scheme['textview_variable']




/*

	Hot-Linking
					*/


// you can disable hot-linking (downloading/source viewing from outside your domain)
$machine['allow_hot_link'] = true;
//
// note: this has no effect on menus, nor embedded menus.

// if you distribute software via the big download sites,
// remember, they usually expect a direct download link (see below).


// IMPORTANT; if no "referer" information is received, the distro
// machine will allow the download, anyway. Remember, the distro
// machine won't allow simultaneous downloads, so download managers
// can't scoop your files.

// This setting is merely to prevent other webmasters linking
// directly to your content.

// If you feel strongly about this, and want to disable hot-linking
// even for requests with empty referrers (which could be valid browsers
// who have disabled this - I wish they bloody wouldn't! effin breaking the
// web! - or perhaps other entities) then set 'hot_link_strict' to true..
$machine['hot_link_strict'] = false;
//
// NOTE: if you set hot_link_strict to true, it's unlikey you will be
// able to view embedded source highlighting, even on your own site!


// if you disable hot-linking, rather than the file, they get some plain text..
$machine['hot_link_message'] = 'no hotlinking allowed, sorry.';

// or some old-school trick..
//$machine['hot_link_message'] = '<meta http-equiv="refresh" content="1; url=http://corz.org">';

// or whatever..
//$machine['hot_link_message'] = '<meta http-equiv="refresh" content="1; url=http://'.$_SERVER['HTTP_HOST'].$machine['self'].'">';


/*
	Insist on cookies

	If you want overload protection to work all the time, set this to true.
	This also helps ensure spidering entities don't go scooping all your downloads.

	All web browsers can do cookies.
	If they want your resources, they can easily enable them.

	NOTE: these are only temporary (session) cookies.
													*/
$machine['insist_in_cookies']	=	true;

/*
	!:::!:::! !:::!:::! !:::!:::! IMPORTANT !:::!:::! !:::!:::! !:::!:::!

	If you insist on cookies, you must remember to set this cookie first! If you
	are using regular menus, the distro machine will do this for you when the
	menu is loaded, but if you are simply placing links on pages, or embedding
	menus with readfile(), there will be no cookie present when the download
	begins, and it will be denied. To solve this, set the cookie in your calling
	page/site header/etc.

	It's a simple session cookie, set it like this (after session_start())..

	$_SESSION['machine']['got_cookie'] = true;
*/

/*

	Approved cookie-less hot-linkers..

	If you use the distro machine to distribute software that is promoted on the
	download sites, brothersoft.com, etc., and also insist_on_cookies (above),
	you will need to enable "cookieless" downloading for these sites, or else
	their downloads will fail (because they haven't visited a menu page, first).
	These sites must also be allowed to hot-link. This setting takes care of all
	that.

	Enter the domains of all sites you wish to allow cookieless hot-linking.
	separated entries by commas. You can also be more specific and specify the
	exact page, if you wish (partial domain matches are fine, i.e. for
	kde-window-sizer.uptodown.com and and the likes) ..
																				*/
$machine['cookieless']	=	'shirtware.org,brothersoft.com,download.com,tucows.com,uptodown.com';


/*
	Reset Limit.

	In the event of a user attempting to download a file they have previously downloaded,
	the distro machine gives the user a friendly message, with an email link, and an
	option to reset their downloading session and try again.

	Menaces, and automatic entities could get wise to this function and bypass your cool
	protections, download files zillions of times, eat bandwidth, etc, so the a limit is
	set on exactly how many times they can reset their download session. You can configure
	this limit here.

	When the *total* number of resets goes *above* this number, the distro machine will
	instead display an error message with a mail link. If the reset count reaches twice
	this number, the page simply dies.
																					*/
$machine['reset_limit']		=	10;



/*

	Display Last Modified Time in Tooltip

	Along with the file size, you can also display the last modified time of
	your files. This will appear in the pop-up ToolTip the user gets when they
	hover over any file link.
																			*/
$machine['view_mod_times'] = true;



// The facility exists to place a "system message" on all pages generated by the
// distro machine.
$machine['system_message'] = '';


/*

	end preferences
	on with the show..

						*/




//// not used yet
//$machine['dont_descend']				= '/inc,/img';




// start with any user-defined changed files..
while(list($old_page, $new_page) = each($catchers)) {
	if (stristr($_SERVER['REQUEST_URI'], $old_page)) {
		header('HTTP/1.1 301 Moved Permanently');
		header('Location: http://'.$machine['host'].$new_page);
		die();
	}
}

/*
	get the current path..
	(check where in the *&@$*! (server) we are)
											*/
$machine['path'] = substr(str_replace("\\", '/', dirname(realpath($_SERVER['SCRIPT_FILENAME']))), strlen($machine['root'])).'/';


// get user "arrays" into actual arrays..
//
$machine['file_extensions']				= explode(',', $machine['file_extensions']);
$machine['always_attach']				= explode(',', $machine['always_attach']);
$machine['source_file_extensions']		= explode(',', $machine['source_file_extensions']);


/*
init..	*/
ob_start();
$machine['mode'] = '';
$machine['is_admin'] = $machine['can_see_stats'] = $machine['is_friend'] = false;
$machine['add_title'] = $machine['other_mode'] = $machine['switch_title'] = '';
/* this will be your session for today..
(unless you already have one open - @)	*/
@session_start();



// include essential functions
require_once $machine['functions_location'];

if (isset($machine['textview_location'])) {
	if (file_exists($machine['textview_location'])) {
		include $machine['textview_location'];
	}
}

$user_dl_path = $machine['download_path'];
$user_src_path = $machine['source_path'];




/*
	clean mode?

	are we doing header/footer-less "clean" source highlighting?
	just add "&clean=true" (no quotes) onto your URL for clean source or menu
	embedding (see the install page, or my .htaccess articles, onsite, for more details).
	*/
if (isset($_GET['clean'])) { $machine['embed'] = $_GET['clean']; } else { $machine['embed'] = false; }

// open statistics?
if (empty($machine['password'])) {
	$machine['can_see_stats'] = true;

} else {
	// pajamas authentication..
	$add_root = '';
	$code_loc_base = '';
	if (substr($machine['pajamas_location'], 0, 1) == '/') {
		$add_root = $machine['root'];
	} else {
		$code_loc_base = str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);
	}
	$code_loc_add = str_replace(basename($machine['pajamas_location']), '', $machine['pajamas_location']);

	include $add_root.$machine['pajamas_location'];
	$auth = new pajamas($machine['pajamas_sess_name']);

	// pj prefs..
	$auth->_createForms = true;
	$auth->_default_module = $machine['module'];
	$auth->_no_autocomplete = true;
	$auth->_code_location = $code_loc_base.$code_loc_add.'modules/client-side/md5.js';
	$auth->_login_password = $machine['password'];
	// etc..
	$auth->_check_ip = $machine['check_ip'];
	$auth->_do_time_out = $machine['do_time_out'];
	$auth->_session_time = $machine['session_time'];
	$auth->_big_luser = $machine['big_luser'];


	// no auth, no page..
	if ($auth->auth_user()) {
		$machine['is_admin'] = true;
		$machine['can_see_stats'] = true;
		$machine['is_friend'] = true;
	}
}


// partial encode this before we begin..
// full encode isn't necessary, this simply prevents validation errors..
$machine['self'] = str_replace(' ', '%20', $machine['self']);

/*
do stats..	*/
if ((isset($_GET['stats']) or isset($_POST['auth-login'])) and $machine['stats_link']) {

	// init..
	do_header();

	if (isset($_POST['logout'])) {

		//unset ($_SESSION['machine']['statpass']); // we'll keep any other settings, though
		$jump_link = make_jump_link('please hold..', 2, $machine['self'], true, 'jump to main menu');
		do_message('logout complete!', $jump_link);
		exit;
	}

	if ($machine['is_admin']) {
		if (isset($_GET['del'])) {
			delete_stat($machine['counter_file'], $_GET['del']);
		}
		if (isset($_GET['edit'])) {
			edit_stat($machine['counter_file'], $_GET['edit'], $_GET['file']);
		}
	}


	if ($machine['can_see_stats']) {
		do_stats($machine['counter_file']);
		die('</body>
</html>');

	} else {
		echo '
	<div  class="machine-solo">';
		echo $auth->getAuthCode();
		echo $auth->getLoginForm();
		echo '
	</div>
	<div class="machine-stats-link">
		<a href="',$machine['self'],'" title="up to main menu">return to main menu</a>
	</div>';
		end_page();
		die();
	}
 }

// okay, not looking at stats..

if ($machine['secure_area']) {
	if ($machine['embed']) {
		echo '
<div class="auth-container">
	<div class="machine-auth-title">
		<code>the <a href="',$machine['self'],'" id="corz.distro.machine" title="you will need to login to this machine directly">distro machine</a> you are trying to access is running in secure mode, backend services are not available.</code>
	</div>';
		echo powerbar();
		echo '
</div>';
		return;
	}

	if (isset($_POST['arealogout'])) {
		unset ($_SESSION['machine']['areapass']);
		$jump_link = make_jump_link('please hold..', 2, $machine['self'], true, 'jump to main menu');
		do_message('logout complete!', $jump_link);
		exit;
	}

	if ( (@$_SESSION['machine']['areapass'] == md5($machine['area_password']))
	or ((isset($_POST['area_password'])) and (@$_POST['area_password'] == $machine['area_password'])) ) {
		$machine['is_friend'] = true;
		$_SESSION['machine']['areapass'] = md5($machine['area_password']);
	}

	// present our cute password box..
	if (!$machine['is_friend']) {
		do_header();
		echo '
<form id="statsform" method="post" action="',$machine['self'],'">
<div class="auth-container">
	<div class="machine-auth-title">
		enter your area password
	</div>
	<input type="password" size="30" name="area_password" />';
	echo powerbar();
	echo '
</div>
</form>';

		if ($machine['hide_stats_link']) {
			$tf = '<span class="big">&nbsp;&nbsp;&nbsp;&nbsp;</span>';
		} else { $tf = 'admin'; }
		echo '
<div class="machine-stats-link">
	<a href="',$machine['self'],'?stats=true">',$tf,'</a>
</div>';
		die('
</div>
</body>
</html>
');
	}
}


/*
	version info

	An intersting way to solve the issue of using "empty" keys on some
	servers. Generally we'd have to pass ?version=true to get a response
	(or ?version=bananas, whatever), but now we can just pass ?version
	and the condition is true. passing ?version=true will still work, too.
	handy.

	of course, there's always empty() ;o)
									   */
if (array_key_exists('version',$_GET)) {
	die('corz distro machine, version '.$machine['version']);
}


/*
	in a sub-section?	*/

$machine['in_sub_string'] = '';


if (isset($_GET['section'])) {

	$machine['sub_section'] = $_GET['section'];
	$machine['sub_section'] = str_replace('../', '', $machine['sub_section']);

	// These sections search UP the tree when users supply missing paths..
	// As well as redirecting requests for section /foo/bar/NOT-HERE/ to
	// /foo/bar/, rather than the *root* menu, it also means that if you have
	// a source menu in /foo/bar/SOURCE-ONLY/ and the user switches to downloads
	// they get the /foo/bar/ download menu, which will be closer to where they
	// want to be.
	if (isset($_GET['download']) and $_GET['download'] == 'menu') {
		while (!file_exists($machine['root'].$machine['path'].$machine['download_path'].$machine['sub_section'])) {
			$machine['sub_section'] = explode('/', $machine['sub_section']);
			array_pop($machine['sub_section']);
			$machine['sub_section'] = implode('/', $machine['sub_section']);
		}
	}
	if (isset($_GET['source']) and $_GET['source'] == 'menu') {
		while (!file_exists($machine['root'].$machine['path'].$machine['source_path'].$machine['sub_section'])) {
			$machine['sub_section'] = explode('/', $machine['sub_section']);
			array_pop($machine['sub_section']);
			$machine['sub_section'] = implode('/', $machine['sub_section']);
		}
	} // looks a bit wet!

	if (!empty($machine['sub_section'])) {
		$machine['in_sub_string'] = '?section='.rawurlencode($machine['sub_section']);
		$machine['source_path'] .= $machine['sub_section'].'/';
		$machine['download_path'] .= $machine['sub_section'].'/';
	}

} else { $machine['sub_section'] = ''; }



// yes, you can do href="?source=menu", the 'self' is implicit in html
// but embedded (and syndicated) menus would fail, see.
if (!empty($machine['in_sub_string'])) { $machine['thingie'] = '&amp;'; } else { $machine['thingie'] = '?'; }


/*
	reset the downloading session
	(they were up to something, no doubt)
	*/
if (isset($_POST['reset'])) {
	unset($_SESSION['machine']['downloading']);
}

if (isset($_POST['zero'])) {
	unset($_SESSION['machine']['grabbed']);

	if (!isset($_SESSION['machine']['reset_count'])) {
		$_SESSION['machine']['reset_count'] = 1;
	} else {

		$_SESSION['machine']['reset_count'] += 1;

		if ($_SESSION['machine']['reset_count'] >= ($machine['reset_limit'] * 2)) {
			do_503_kill(60*60*24); // 24h
		}
		if ($_SESSION['machine']['reset_count'] >= $machine['reset_limit']) {
			do_header();
			do_message('
		<span class="big">Clearly something is <em>very</em> &nbsp;wrong.</span><br />
		<br />
		&nbsp;<code>Please <a href="'.mail_masher($machine['admin_email']).
				'?subject=distro%20machine%20error!" title="I want to know about this!" id="mail-owner">mail '.
					$machine['owner'].'</a> about this.</code><br />
		', '');
			end_page();
		}
	}
}


// has the requested file been moved?

$new_section = '';
$find_path = array('./');
$ignore = array('/inc/');

// we don't know what mode we are in, yet, so we check both..
if (!empty($_GET['source']) and $_GET['source'] != 'menu') {

	if (!file_exists($machine['root'].$machine['path'].$machine['source_path'].$_GET['source'])) {
		$find_file = $_GET['source'];
		find_it();
		// update the section string with the new location..
		$new_section = str_replace('./'.$user_src_path, "", substr($new_section, 0, -1));
		$new_section = str_replace('/', "%2F", $new_section);
	}
}

if (!empty($_GET['download']) and $_GET['download'] != 'menu') {
	if (!file_exists($machine['root'].$machine['path'].$machine['download_path'].$_GET['download'])) {
		$find_file = $_GET['download'];
		find_it();
		$new_section = str_replace('./'.$user_dl_path, "", substr($new_section, 0, -1));
		$new_section = str_replace('/', "%2F", $new_section);
	}
}


if ($new_section != '') {
	if (!empty($_GET['source'])) $new_loc = '?ajax=true&source='.$_GET['source'].'&section='.$new_section;
	if (!empty($_GET['download'])) $new_loc = '?ajax=true&download='.$_GET['download'].'&section='.$new_section;
	//uSleep(1250000);
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: http://'.$machine['host'].$machine['self'].$new_loc);
	die();
}



/*
	download CaTcHeR..	*/

if (isset($_GET['download'])) {
	$machine['download_get'] = $_GET['download'];

	$machine['download_get'] = str_replace('../', '', $machine['download_get']);
	// removing the above line would possibly allow someone to download /etc/passwd from your server
	if (($machine['download_get'] != 'menu')
		and !empty($machine['download_get']) and $machine['allow_downloads_services']) {

			// they are already downloading a file..
			if (!isset($_SESSION['machine']['downloading'])) {

				// check for valid session cookie entry
				//
				if ($machine['insist_in_cookies']) {
					if (!got_cookie()) {
					do_header();
					do_message('
				<span style="font-size: large;">To download from the distro machine,<br />
				you must first <a href="http://www.google.com/search?q=enable+cookies"
				title="Click here if you don\'t know how to enable cookies in your browser" id="help-cookies">
				enable <span style="color: red;font-size:x-large;font-weight:800;">cookies!</span></a></span><br />
				<br />

				<span class="auth-note">This prevents abuse by spiders and other bandwidth-sucking automatic entities.</span><br />
				<br />

				<strong><small>With cookies enabled, go back to the menu and refresh the page.<br />
				Thereafter, downloads should work just fine.</small></strong><br />

				', ''.make_back_butt().'<br />
				<br />');
					end_page();
					}
				}

				// check if they have already downloaded this file..
				//


				// we allow THREE downloads. This is to work around a bug in mobile browsers. **
				if (isset($_SESSION['machine']['grabbed'][$machine['download_get']])
				  and $_SESSION['machine']['grabbed'][$machine['download_get']] > 2) {

					do_header();
					do_message('
				<span class="big">you have already downloaded that file!</span><br />
				(check your downloads folder)', ''.make_back_butt().'<br />
				<br />

				If you believe this is an error, <a href="'.mail_masher($machine['admin_email']).
				'?subject=distro%20machine%20error!" title="I want to know about this!" id="mail-owner">mail '.
					$machine['owner'].'</a> about it.<br />

				Alternatively, reset your downloading session and try again..<br />
				<br />
				<form method="post" action="'.$machine['self'].'?section='.$machine['sub_section'].'&amp;download=menu" name="zero"><input type="submit" value="reset" name="zero">');
					end_page();

				}


				// you don't wanna stop this mid-flow..
				ignore_user_abort(true);

				// just downloaded that file!!! //:2do	??? what? dude! write better notes!

				$downloaded = go_download($machine['download_get']);

				if ($downloaded) {
					if (!isset($_SESSION['machine']['grabbed'][$machine['download_get']])) {
						$_SESSION['machine']['grabbed'][$machine['download_get']] = 0;
					}

					// ** alternatively, we might only increase the counter under certain conditions
					$_SESSION['machine']['grabbed'][$machine['download_get']] += 1;

					if (isset($_SESSION['machine']['downloading'])) { // it may not be set
						unset($_SESSION['machine']['downloading']);
					}
				}
				exit();

			} else {

				do_header();
				do_message('you are already downloading<br /><br />
				<code>'.$_SESSION['machine']['downloading'].'</code><br /><br /> from corz distro machine!</strong>', 'if you believe this is an error, press this button..<br /><br /><form method="post" action="'.$machine['self'].'?section='.$machine['sub_section'].'" name="reset"><input type="submit" value="reset" name="reset"><br /><br />to reset your downloading session and try again');
				end_page();
				die;
			}
	}
} else { $machine['download_get'] = ''; }



if (isset($_GET['source'])) {
	$machine['source_get'] = $_GET['source'];
	// or they might prefer to view your system files directly..
	$machine['source_get'] = str_replace('../', '', $machine['source_get']);
} else {
	$machine['source_get'] = '';
}



/*
	webmaster sanity checks

	if one mode isn't available for some reason; if it's allowed;
	we'll have to use the other mode, regardless of the default..
																	*/

if (!$machine['show_download_menu'] or empty($machine['download_path']))	{
	$machine['default_mode'] = 'source';
} elseif (!$machine['show_source_menu'] or empty($machine['source_path'])) {
	$machine['default_mode'] = 'download';
}

/*	it's easier on my brain when I split it up like this
	check that menu config is okay for real folders, and visa-versa
																	*/
if ($machine['download_get'] == 'menu' and $machine['show_download_menu'])	$machine['mode'] = 'download';
if ($machine['source_get'] == 'menu' and $machine['show_source_menu'])		$machine['mode'] = 'source';


// user has arrived straight at the distro machine.. (no $_GET variables)
if (empty($machine['mode'])) {
	if ($machine['show_download_menu'] and ($machine['default_mode'] == 'download')) {
		$machine['mode'] = 'download';
	} elseif ($machine['show_source_menu'] and ($machine['default_mode'] == 'source')) {
		 $machine['mode'] = 'source';
	}
}

// finally..
if (!$machine['show_download_menu'] and !$machine['show_source_menu']) $machine['mode'] = '';


/*
	do mode specifics..   */


if ($machine['mode'] == 'download') {
	$machine['question'] = $machine['downloads_title'].' menu..';
	$machine['other_mode'] = 'source';
} elseif ($machine['mode'] == 'source') {
	$machine['question'] = $machine['source_title'].' menu..';
	$machine['other_mode'] = 'download';
} else {
	$machine['question'] = 'Nothing to see here. Move along..';
}

if (!empty($machine['sub_section'])) {
	$machine['switch_to'] = $machine['other_mode'];
	$machine['switch_title'] =  'switch to '.$machine['switch_to'].' menu';
	//$machine['other_mode'] = $machine['mode'];
} else {
	$machine['switch_title'] = 'switch to '.$machine['other_mode'].' menu';
}

// if only one mode is available, there's no need for a switch title..
if (!$machine['show_download_menu'] or !$machine['show_source_menu']) $machine['switch_title'] = '';

// title addition..
$addsub = ''; if ($machine['sub_section']) { $addsub = $machine['sub_section'].'/'; }
if (!empty($machine['source_get'])) {
	$machine['add_title'] = $machine['mode'].'/'.$addsub.$machine['source_get'];
} else {
	$machine['add_title'] = $machine['mode'].'/'.$addsub.$machine['download_get'];
}
if ($machine['add_title'] == 'menu') {
	$machine['add_title'] = $machine['mode'].' menu';
}


/*
	clean mode?
	*/

/*

These may be over-ridden with $_GET variables..
												*/
$machine['embedded_custom_text']		= false;
$machine['embedded_section_titles']		= false;
$machine['embedded_sections_menus']		= false;

if ($machine['embed']) {

	// check for embedding options..
	if (isset($_GET['text'])) {
		if ($_GET['text'] == 'true') {
			$machine['embedded_custom_text'] = true;
		}
	}
	if (isset($_GET['titles'])) {
		if ($_GET['titles'] == 'true') {
			$machine['embedded_section_titles'] = true;
		}
	}
	if (isset($_GET['sections'])) {

		if ($_GET['sections'] == 'true') {
			$machine['embedded_sections_menus'] = true;
		}
	}

} else {
	$machine['embed'] = false;
	do_header();
}


// set this cookie now - will check before downloading (above)
// (if "insist_on_cookies" is true)
$_SESSION['machine']['got_cookie'] = true;

/*
	source viewing..

	is this a valid source file for viewing? we're being strict here
	folks *will* try to use your machine to view other site's source, duh.
									*/
if (!empty($machine['source_get']) and $machine['source_highlighting']) {

	check_hotlinking();

	if (file_exists($machine['source_path'].$machine['source_get'])) {
			do_source_view($machine['source_get']);
			if (!$machine['embed']) {
				end_page();
			}
			die();
	}
}





/*
	no valid source file was requested
	do machine menus..	*/


if ($machine['mode'] != '') {


	/*
		the whole thing mainly runs inside one big div
		each section has its own style name, so you can
		lay it out however you like.
									*/


	// for clean (embedded) pages..
	if (!$machine['embed']) {
		echo '
	<div class="machine-solo">';
	} else {
		echo '
	<div class="machine-embedded">';

	}

	// with logout button for protected area..
	if ($machine['secure_area']) {

		if (!$machine['is_admin']) {
			echo '
		<form id="logout-form" action="',$machine['self'],'" method="post">
		<div class="auth-logout">
			<input type="submit" value="logout" name="arealogout" />
		</div>
		</form>';
		} else {
			echo $auth->getLogoutButton();
		}
	}

	if (!$machine['embed']) {
		/*
		the "question"..
		you can do your own lead-in titles on embedding pages..	*/

		//2do - check source enabled!
		echo '
		<div class="machine-question">
			<a href="',make_switch_href(),'" title="',$machine['switch_title'],'">',$machine['question'],'</a>
		</div>
		<div class="clear"></div>';
	}


	// wherever we are, we are in our box..
	// we begin indentation from scratch.
	echo '
	<div class="machine-box">';


	/*
		scan the directory..
		we'll do this in two stages.	*/

	if ($machine['mode'] == 'download') $machine['source_path'] = $machine['download_path'];
	if ($the_dir = @opendir($machine['root'].$machine['path'].$machine['source_path'])) {

		$q=0; $z=0;
		while (false != ($file = readdir($the_dir))) {
			$fext = substr($file, strrpos($file, '.') + 1);

			if ($machine['mode'] == 'source') { /*
					no invisibles (beginning with a dot, which may share same extensions - mac resource forks)
					you could add more extensions here, though it would be fairly pointless.
					I'm have a text viewer for other file types, check *my* machine! */
				if (in_array($fext, $machine['source_file_extensions'])
					and (ord($file) != 46) and (basename($file) != basename($_SERVER['SCRIPT_NAME']))) { // starts with a . (dot) //:2do.. 'self'!!!
					$itemz[$q++] = basename($file);
				}
			} else {
				// must be the download menu..
				if ($machine['show_all_files']) {
					if ((ord($file) != 46) and (!is_dir($machine['source_path'].$file))) {
					$itemz[$q++] = basename($file);
					}
				} else {
					if ((in_array(strtolower($fext), $machine['file_extensions'])) and (ord($file) != 46)) {
					$itemz[$q++] = basename($file);
					}
				}
			}
			if (($machine['do_sections']) and (is_dir($machine['source_path'].$file)) and (ord($file) != 46)) {
				$sectionz[$z++] = basename($file);
			}
		}
	closedir($the_dir);
	}



	/*
		grab custom text from file..
										*/
	$machine['custom_text'] = '';
	if ((file_exists($machine['source_path'].$machine['custom_text_file'])
		and ((!$machine['embed']) or $machine['embedded_custom_text']))) {

		$machine['custom_text'] = '';
		$custom_text_data = trim(implode('', file($machine['source_path'].$machine['custom_text_file'])));

		// only need up to the [links] section, which we will ini-parse for source-viewer page links
		if ($i = strpos($custom_text_data,'[')) {
			$machine['custom_text'] = substr($custom_text_data, 0, $i);
		} else {
			$machine['custom_text'] = $custom_text_data;
		}

		// this section enables you to put your special links inside an HTML comment
		// and re-use your local readme file for other scripts (e.g. thumber)..
		if ( strstr($machine['custom_text'], '<!-') and !strstr($machine['custom_text'], '>')
		  or (strrpos($machine['custom_text'], '<!-') > strrpos($machine['custom_text'], '>' ))
			) {
			$machine['custom_text'] = substr($machine['custom_text'], 0, strrpos($machine['custom_text'], '<!-'));
		}
	}


	/*
			the menu box		*/


	echo '
		<div class="machine-menu">';

	// if we are running embedded, add pop-up to section link..
	if ($machine['embed']) { $pop = 'onclick="window.open(this.href); return false;"'; } else { $pop = ''; }

	/*
		create menu	items..
		we have the arrays now, let's spit them out
													*/


	/*
		first the "sections" side of the box..
														 */


	/*
		on my site, the sections are on the left, so I coded it in that order, but I
		also coded it so that you can flip the panels by doing no more than changing
		two float value in your css.

	*/


	if ((@count($itemz) > 0) or (@count($sectionz) > 0)) {

		if ($machine['embedded_section_titles'] or $machine['embedded_sections_menus'] or !$machine['embed']) {
			echo '
			<div class="machine-section-menu">';
			if ($machine['embedded_section_titles'] or !$machine['embed']) {
				// sections title..
				do_sections_title($machine['sections_title'],'big');
				// sub-sections..
				if ($machine['sub_section']) {
					do_sections_title($machine['sub_section'],'sub');
				}
			}
		}


		if ($machine['embedded_sections_menus'] and !$machine['embedded_section_titles'] and $machine['embed']) {
			// insert a fake title div to move the sections down..
			echo '
				<div class="machine-sections-title">
					&nbsp;
				</div>';

			}
		if ($machine['embedded_sections_menus'] or !$machine['embed']) {
			/*
			will we present a "sections" menu?..	*/
			if (isset($sectionz) and is_array($sectionz)) {
				sort ($sectionz); // a-z (filesystem will present them anywhichway, see)

			/*
				"sections" menu (subfolders)
				[only show sections menu at the top level..]
																*/
				echo '
				<div class="machine-section-list">';

				if ($machine['sub_section']) { $pre = $machine['sub_section'].'/'; }   else { $pre = ''; }
				for ($a = 0, $sections_count = count($sectionz); $a < $sections_count; $a++) {
					if ($a == $sections_count) {
						break;
					} else {
						$machine['section_name'] = $sectionz[$a];
						echo '
					<a href="',$machine['self'],'?',$machine['mode'],'=menu&amp;section=',rawurlencode($pre.$machine['section_name']),'"
					title="enter ',$machine['section_name'],'" ',$pop,'>'
					,substr($machine['section_name'], strpos('/', $machine['section_name'])),'</a><br />';
					}
				}
				echo '
				</div>'; //close: "machine-section-list"
			}
		}
		if ($machine['embedded_section_titles'] or $machine['embedded_sections_menus'] or !$machine['embed']) {
			echo '
			</div>';// close "machine-section-menu"
		}

		/*
			end "sections" side..
								 */



		/*
			the "files" menu side of the box..
														*/


		$menu_style = 'machine-files-menu';
		if (!$machine['embedded_section_titles'] and !$machine['embedded_sections_menus'] and $machine['embed']) {
			$menu_style = 'machine-files-lone';
		}

		echo '

			<div class="',$menu_style,'">
				<div class="machine-files-title">
					',$machine['mode'],' files..
				</div>
				<div class="machine-file-list">';

		/*
		any files to display?..	*/

		if (@count($itemz) > 0) {

			sort ($itemz);
			$dirsize = @count($itemz);
			for ($a = 0; $a < $dirsize; $a++) {
				if ($a == $dirsize){
					// reached the end of the dir.
					break;
				} else {
					$source_file = $itemz[$a];
					$source_file_name = str_replace('_',' ', $source_file);
					$source_file_name = str_replace('-',' ', $source_file_name);

					$modified_time = '';
					if ($machine['view_mod_times']) {
						$modified_time = '[modified: '.get_filetime($machine['root'].$machine['path'].$machine['source_path'].$source_file).']';

					}
					if ($machine['mode'] == 'source') {

						echo '
					<a href="',$machine['self'],$machine['in_sub_string'],$machine['thingie'],'source=',
						rawurlencode($source_file),'" title="view the source for ',basename($source_file),
						' [',do_nice_filesize($machine['root'].$machine['path'].$machine['source_path'].$source_file),']
',$modified_time,'" ',$pop,'>',$source_file_name,'</a><br />';

					} else { // download..
						echo '
					<a href="', $machine['self'], $machine['in_sub_string'], $machine['thingie'],
						'download=', rawurlencode($source_file), '" title="download: ', basename($source_file),
						' [',do_nice_filesize($machine['root'].$machine['path'].$machine['source_path'].$source_file),']
',$modified_time,'"> ',$source_file_name,'</a><br />';
					}
				}
			}

		} else {

			if (@count($sectionz) > 0) {
				echo '
					no files here<br />
					try a subsection<br />';
			}
		}
		echo '
				</div>';//close:"machine-file-list"
		echo '
			</div>';//close:"machine-files-menu"

	/*
			end "files" side..
									*/


	} else {

		/*

		no menu

		if the distro machine is functioning purely as a backend download
		engine and both menu's are disabled, this is what the user gets.

		they can also end up here by attempting to download files directly,
		attempting to access your download folder directly when you have the
		menus disabled, or if you genuinely have no files in the relevant
		folder..

		*/

		//	files side..
		echo '
			<div class="machine-files-menu">
				<div class="machine-files-title">
					<strong><span class="big">nothing available!</span></strong>
				</div>
			</div>';


		// sections side..
		echo '
			<div class="machine-section-menu">';
		if ($machine['embedded_section_titles'] or !$machine['embed']) {
			do_sections_title($machine['sections_title'], 'big');
			do_sections_title($machine['sub_section'], 'sub');
		}
		echo '
			</div>';// close "machine-section-menu"
	}



	/*
	any custom text?	*/
	if (!empty($machine['custom_text'])) {
		echo '
			<div class="clear-tiny"></div>
			<div class="machine-custom-text">
				',$machine['custom_text'],'
			</div>';
	} else {
		echo '
		<div class="clear-tiny"></div>';
	}

	echo '
		</div>'; // close "machine-menu"
	echo '
		<div class="clear"></div>
	</div>';// close "machine-box"

	/*
	the powered-by box..*/
	echo powerbar($machine['bottom_switch']);

	echo '
	</div>';// close main "machine-solo" or "machine-embedded", depending.


	if (!$machine['embed'] and $machine['system_message']) {
		echo '
	<div id="machine-system-msg">
		',$machine['system_message'],'
	</div>';
	}

	/*
	all done with the main machine now	*/

} else {

	echo '
	<div class="machine-solo">
	<div class="machine-question">
		',$machine['question'],'
	</div>
	<div class="clear"></div>
	</div>';
}

/*
	stats link..   */

if ($machine['stats_link'] and !$machine['embed']) {
	if ($machine['hide_stats_link']) { $tf = '<span class="big">&nbsp;&nbsp;&nbsp;&nbsp;</span>'; } else { $tf = 'stats'; }
	echo '
<div class="machine-stats-link">
	<a href="',$machine['self'],'?stats=true">',$tf,'</a>
</div>';
}

if (!$machine['embed']) {
	end_page();
}



	/*
		fin
			  */


/*
   you have reached the end of the program.
*/

